function bp_params = update_bp_params(Y, model)

% Updates the parameters of the back-mapping functions. It first prepares
% the data, and then calls the Leave-One-Out Kernelized ridge least square
% function to find the optimal values for the regression.

bp_params = model.bp_params;
adm_params = model.adm_params;

num_mod = numel(Y);

[N, D] = size(model.X);


%% Initialize parameteres of back projections
lambda = zeros(num_mod,1);
gamma = zeros(num_mod,1);
log_w = [];

for i = 1:num_mod
    lambda(i) = bp_params(i).lambda;
    gamma(i) = bp_params(i).gamma;
    if model.sbp
        if i==1, log_w = zeros(num_mod,1); end
        log_w(i) = bp_params(i).log_w;
        lambda = bp_params(1).lambda;
    end
end
params = [log_w(:); lambda(:); gamma(:)];


%% Call the optimization function
options.METHOD = 'scg';
options.cgUpdate = 1;
% options.DERIVATIVECHECK = 'on';
options.maxIter=1000;
options.maxFunEvals = 10;
[params, E_loo] = minFunc(@loo_krls_new, params, options, Y, model);

%% Update the parameters 
if model.sbp
    log_w = params(1:num_mod);
    lambda = repmat(params(num_mod + 1), num_mod);
    gamma = params(num_mod+1+1:end);
    w = exp(log_w)./sum(exp(log_w));
    K_tilda = 0;
else
    lambda = params(1:num_mod);
    gamma = params(num_mod+1:end);
end
for i = 1:num_mod
    bp_params(i).lambda = lambda(i);
    bp_params(i).gamma = gamma(i);
    
    bp_params(i).K = covSEisoU(log(bp_params(i).gamma), Y{i});      % compute the new kernel
    
    if model.sbp
        bp_params(i).log_w = log_w(i);
        bp_params(i).w = w(i);
        K_tilda = K_tilda + bp_params(i).w .* bp_params(i).K;       % the weighted sume of the kernels
        if i==num_mod
            M = K_tilda + bp_params(1).lambda/model.adm_params(1).mu * eye(N);
            M = [M ones(N,1); ones(1,N) 0];
            invM = M \ eye(N+1);
            A = invM * ([model.X + adm_params(1).Lambda/adm_params(1).mu; ones(1,D)]);      % the new value for the regression parameters
            
            [bp_params.K_tilda] = deal(K_tilda);
            [bp_params.M] = deal(M);
            [bp_params.invM] = deal(invM);
            [bp_params.A] = deal(A);
        end
    else
        bp_params(i).K_tilda = bp_params(i).K;
        bp_params(i).M = bp_params(i).K + bp_params(i).lambda/adm_params(i).mu * eye(N);
        bp_params(i).M = [bp_params(i).M ones(N,1); ones(1,N) 0];
        bp_params(i).invM = bp_params(i).M \ eye(N+1);
        
        bp_params(i).A = bp_params(i).invM * ([model.X + adm_params(i).Lambda/adm_params(i).mu; ones(1,D)]);
    end
end

end

