function model = myPCA(X,var)

% It returns the Principal eigenvectors with the corresponding eigenvalues
% sorted from highest to lowest.
%
% params holds the projections of the original data X to the subspace
% defined by the eigenvectors.
% 
% var can be either integer (it will return the specified number of
% eigenvectors) or percentage (e.g. 0.95 to retain the 95% of the variance)

[N,D] = size(X);

[X, mu] = standardize(X, 1);
model.mean = mu;
model.X = X;

if D<N
    S = X'*X;
else
    S = X*X';
end

[eigenvectors, eigenvalues] = eig(S);

eigenvalues = diag(eigenvalues);
[eigenvalues, ind] = sort(eigenvalues, 'descend');
eigenvectors = eigenvectors(:, ind);

total_var = cumsum(eigenvalues)./sum(eigenvalues);
if var < 1
    dim = find(total_var >= var, 1);
else 
    dim = var;
end

eigenvalues = diag(eigenvalues(1:dim));
eigenvectors = eigenvectors(:, 1:dim);

if ~(D<N)
    eigenvectors = X' * eigenvectors * diag(diag(eigenvalues) .^ (-1/2));
end

model.eigenvalues = eigenvalues;
model.eigenvectors = eigenvectors;
model.params = X * eigenvectors;
end