function [E_loo, dE_loo] = loo_krls_new(params, Y, model)

% Leave-One-Out Kernelized ridge least square. Finds the solution to the
% kernel ridge regression problem
%
% params: the vector that contains the parameters [log(w), lambda, gamma]^T
%         which we want to find with the LOO scheme. If IBP is selected
%         log(w) is empty.
%
%
% It needs cleaning of some parts


[N,D] = size(model.X);
num_mod = numel(Y);
mu = model.adm_params(1).mu;
% if model.ibp || model.sbp
%     mu = model.adm_params(1).mu;
% else
%     mu = 1;
% end

% if model.sbp
%     log_w = params(1:num_mod);
%     lambda = repmat(params(num_mod + 1), num_mod);
%     gamma = params(num_mod+1+1:end);
%     w = exp(log_w)./sum(exp(log_w));
%     K_tilda = 0;
% else
%     lambda = params(1:num_mod);
%     gamma = params(num_mod+1:end);
% end

if model.sbp
    log_w = params(1:num_mod);
    lambda = params(num_mod + 1);
    gamma = params(num_mod+2:end);
    w = exp(log_w)./sum(exp(log_w));        % transform the weights
    denom = sum(exp(log_w));
    
    K_tilda = 0;
    for i = 1:num_mod
        K{i} = covSEisoU(log(gamma(i)), Y{i});
        dK{i} = covSEisoU(log(gamma(i)), Y{i}, [], 1)./gamma(i);    % derivatives of K w.r.t length scale
        K_tilda = K_tilda + w(i) * K{i};
        
        dMdg{i} = w(i).*dK{i};  % derivatives of M w.r.t length scale
        dMdg{i} = [dMdg{i} zeros(N,1); zeros(1,N), 0];
    end
    for i = 1:num_mod       % find derivatives w.r.t the weights.
        dMdw{i} = 0;
        for j = 1:num_mod
            if i == j
                dMdw{i} = dMdw{i} + (exp(log_w(j)) .* denom - exp(2*log_w(j))) ./ (denom.^2) .* K{j};
            else
                dMdw{i} = dMdw{i} - (exp(log_w(j)).*exp(log_w(i))) ./ (denom.^2) .* K{j};
            end
        end
        dMdw{i} = [dMdw{i} zeros(N,1); zeros(1,N), 0];
    end
    
    % Compute the matrices M and the diagonal D
    M{1} = K_tilda + lambda/mu * eye(N);
    M{1} = [M{1} ones(N,1); ones(1,N) 0];
    
    invM = M{1} \ eye(N+1);
    
    
    D_diag = diag(1 ./ diag(invM));
    
    % Compute the current value of the parameters of the regression.
    A{1} = invM * ([model.X + model.adm_params(1).Lambda/mu; ones(1,D)]);

elseif model.ibp
    for i = 1:num_mod
        lambda = params(i);
        gamma = params(num_mod + i);
        K{i} = covSEisoU(log(gamma), Y{i});
        dK{i} = covSEisoU(log(gamma), Y{i}, [], 1)./gamma;
        M{i} = K{i} + lambda/mu * eye(N);
        
        M{i} = [M{i} ones(N,1); ones(1,N) 0];
        
        invM{i} = M{i} \ eye(N+1);
        
        dMdg{i} = [dK{i} zeros(N,1); zeros(1,N), 0];
        
        D_diag{i} = diag(1 ./ diag(invM{i}));
        
        A{i} = invM{i} * ([model.X + model.adm_params(i).Lambda/mu; ones(1,D)]);
    end
end

E_loo = 0;
dEdw = {};   

%% Compute the derivatives of the cost of the LOO w.r.t. w, lambda, gamma.
if model.sbp
    Lambda = [model.adm_params(1).Lambda; ones(1,D)];
    
    dMdl = [(1./mu)*eye(N) zeros(N,1); zeros(1,N) 0];
    
    E_loo = E_loo + norm(D_diag * A{1} - Lambda/mu, 'fro')^2/2;
    
    dEdA = D_diag' * (D_diag * A{1} - Lambda/mu);
    dEdKl =  diag(diag(D_diag * A{1} * A{1}' -  Lambda * A{1}'/mu));
    
    dAdl = -invM * dMdl * A{1};% / mu;
    
    dKdl = -D_diag.^2 .* diag(diag(-invM * dMdl * invM));% / mu));
        
    dEdl = {trace(dEdA' * dAdl) + trace(dEdKl' * dKdl)};
    
    for i = 1:num_mod
        dAds{i} = -invM * dMdg{i} * A{1};
        dAdw{i} = -invM * dMdw{i} * A{1};
        
        dKds{i} = -D_diag.^2 .* diag(diag(-invM * dMdg{i} * invM));
        dKdw{i} = -D_diag.^2 .* diag(diag(-invM * dMdw{i} * invM));
        
        dEds{i} = trace(dEdA' * dAds{i}) + trace(dEdKl' * dKds{i});
        dEdw{i} = trace(dEdA' * dAdw{i}) + trace(dEdKl' * dKdw{i});
    end
        
elseif model.ibp

    for i = 1:num_mod
        Lambda = [model.adm_params(i).Lambda; ones(1,D)];
        
        dMdl = [(1./mu)*eye(N) zeros(N,1); zeros(1,N) 0];
        
        E_loo = E_loo + norm(D_diag{i} * A{i} - Lambda/mu, 'fro')^2/2;
            
        dEdA{i} = D_diag{i}' * (D_diag{i} * A{i} - Lambda/mu);
        
        dEdKl{i} =  diag(diag(D_diag{i} * A{i} * A{i}' -  Lambda * A{i}'/mu));
        
        dAdl{i} = -invM{i} * dMdl * A{i};% / mu;
        dAds{i} = -invM{i} * dMdg{i} * A{i};
        
        dKdl{i} = -D_diag{i}.^2 .* diag(diag(-invM{i} * dMdl * invM{i}));% / mu));
        dKds{i} = -D_diag{i}.^2 .* diag(diag(-invM{i} * dMdg{i} * invM{i}));
        
        dEdl{i} = trace(dEdA{i}' * dAdl{i}) + trace(dEdKl{i}' * dKdl{i});
        dEds{i} = trace(dEdA{i}' * dAds{i}) + trace(dEdKl{i}' * dKds{i});
        
    end
end
dE_loo = [cell2mat(dEdw)'; cell2mat(dEdl)'; cell2mat(dEds)'];
end