function model = initialize_params(data_in, model)

% Sets the ADM and the back-mapping parameters of the DS-GPLVM to their
% defaults:
%
% bp_params(num_mod).A                  % parameters of the kernel regression back-mapping
% bp_params(num_mod).K                  % The Kernel of the back-mapping
% bp_params(num_mod).gamma              % length scale of the kernel regression
% bp_params(num_mod).lambda             % jitter (diagonal term) of kernel
% bp_params(num_mod).w                  % weight of the sum of the kernels (for SBP only)
% bp_params(num_mod).log_w              % weigth in log scale (for SBP only)
% bp_params(num_mod).K_tilda            % sum of the kernels sum_v K^{(v)} (for SBP only)

[N,D] = size(model.X);
num_mod = numel(data_in);

Y = cell(num_mod,1);
for i = 1:numel(data_in)
    Y{i} = standardize(data_in{i}(model.ind{1},:), 1);
end

if model.bp
    gamma = find_heuristic_ell(Y{1}');
    bp_params.gamma = gamma;
    bp_params.K = covSEisoU(log(bp_params.gamma), Y{1});
    bp_params.A = (bp_params.K + 1e-8 * eye(N)) \ model.X;
    bp_params.A = [bp_params.A; ones(1,D)];
    model.bp_params = bp_params;
    model.T = 1;
elseif model.sbp || model.ibp
    adm_params(num_mod).Lambda = [];            % Lagrange multipliers
    adm_params(num_mod).mu = [];                % penalty parameter of the constraint
    adm_params(num_mod).norm = [];              % Frobenius norm of |X-KA|
    
    bp_params(num_mod).A = [];                  % parameters of the kernel regression back-mapping
    bp_params(num_mod).K = [];                  % The Kernel of the back-mapping
    bp_params(num_mod).gamma = [];              % length scale of the kernel regression
    bp_params(num_mod).lambda = [];             % jitter (diagonal term) of kernel
    bp_params(num_mod).w = [];                  % weight of the sum of the kernels (for SBP only)
    bp_params(num_mod).log_w = [];              % weigth in log scale
    
    K_tilda = 0;                                % sum of the kernels sum_v K^{(v)} (for SBP only)
    
    for i = 1:num_mod
        
        
        adm_params(i).Lambda = zeros(size(model.X));
        adm_params(i).mu = 1.25/norm(model.X);              % initialize to heuristic
        
        gamma = find_heuristic_ell(Y{i}');                  % initialize gamma
        bp_params(i).gamma = gamma;
        bp_params(i).lambda = 1e-1;                         % initialize lambda
        bp_params(i).A = zeros(N+1,D);
        bp_params(i).K = covSEisoU(log(bp_params(i).gamma), Y{i});
        
        if model.sbp
            bp_params(i).log_w = 0;
            bp_params(i).w = 1/num_mod;
            K_tilda = K_tilda + bp_params(i).w * bp_params(i).K;
            if i==num_mod
                M = K_tilda + bp_params(i).lambda/adm_params(i).mu * eye(N);
                M = [M ones(N,1); ones(1,N) 0];
                
                [bp_params.K_tilda] = deal(K_tilda);
                [bp_params.M] = deal(M);
            end
        else
            bp_params(i).K_tilda = bp_params(i).K;
            bp_params(i).M = bp_params(i).K + bp_params(i).lambda/adm_params(i).mu * eye(N);
            bp_params(i).M = [bp_params(i).M ones(N,1); ones(1,N) 0];
        end
    end
    
    model.bp_params = bp_params;
    model.adm_params = adm_params;
    model.T = 200;                  % adm cycles
end