function K = covConst_mod(hyp, x, z, i)

% Modified version of the original covConst.m function of Rasmussen. It has
% been modified to compute derivatives w.r.t the inputs x.
%
% covariance function for a constant function. The covariance function is
% parameterized as:
%
% k(x^p,x^q) = s2;
%
% The scalar hyperparameter is:
%
% hyp = [ log(sqrt(s2)) ]

if nargin<2, K = '1'; return; end                  % report number of parameters
if nargin<3, z = []; end                                   % make sure, z exists
xeqz = numel(z)==0; dg = strcmp(z,'diag') && numel(z)>0;        % determine mode

s2 = exp(2*hyp);                                                            % s2
n = size(x,1);

if dg                                                               % vector kxx
  K = s2*ones(n,1);
else
  if xeqz                                                 % symmetric matrix Kxx
    K = s2*ones(n);
  else                                                   % cross covariances Kxz
    K = s2*ones(n,size(z,1));
  end
end

if nargin>3                                                        % derivatives
  if i==1
    K = 2*K;
  elseif i==100
      K = 0;
  else
    error('Unknown hyperparameter')
  end
end