function [smse_test, smse_train, Y_star_test, Y_star, snll] = reconstruction_error(hyp, covfunc, X, Y, mu, Y_test)

% It projects the test data from the learned manifold back to the original
% high-dimensional spaces.

if iscell(X)
    [N, D] = size(X{1});
else
    [N, D] = size(X);
end

for i = 1:numel(Y)
    sn2 = exp(2*hyp{i}.lik);
    K = feval(covfunc{:}, hyp{i}.cov, X);
    L = chol(K/sn2 + eye(N));
    alpha = solve_chol(L, Y{i})/sn2;
    Y_star{i} = K'*alpha;
    
    kss = feval(covfunc{:}, hyp{i}.cov, X, 'diag');
    V = L'\K;
    s2_train = kss - sum(V.*V)'/sn2 + sn2;
    
    Ks = feval(covfunc{:}, hyp{i}.cov, X, mu);
    Y_star_test{i} = Ks'*alpha;
    
    kss = feval(covfunc{:}, hyp{i}.cov, mu, 'diag');
    V = L'\Ks;
    s2 = kss - sum(V.*V)'/sn2 + sn2;
    
    smse_test(i) = norm(bsxfun(@times, Y_star_test{i}-Y_test{i}, 1./sqrt(s2)), 'fro').^2/length(Y_test{i});
    smse_train(i) = norm(bsxfun(@times, Y_star{i}-Y{i}, 1./sqrt(s2_train)), 'fro').^2/N;
    
    diff_train = sum((Y{i} - Y_star{i}).^2,2);
    nll_train = mean(.5*log(2*pi*s2_train) + .5*diff_train./s2_train);
    
    diff_test = sum((Y_test{i} - Y_star_test{i}).^2,2);
    nll_test = mean(.5*log(2*pi*s2) + .5*diff_test./s2);
    
    snll(i) = mean(nll_test) - mean(nll_train);
end

end